/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.handlers;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.entity.INetworkUpdateableEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.client.screen.AbstractChiselsAndBitsScreen;
import mod.chiselsandbits.api.client.sharing.IPatternSharingManager;
import mod.chiselsandbits.api.client.sharing.PatternIOException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.screens.widgets.ChangeTrackerOperationsWidget;
import mod.chiselsandbits.clipboard.CreativeClipboardUtils;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.network.packets.GivePlayerPatternCommandPacket;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class ClientPacketHandlers {
    private ClientPacketHandlers() {
        throw new IllegalStateException("Can not instantiate an instance of: ClientPacketHandlers. This is a utility class");
    }

    public static void handleTileEntityUpdatedPacket(BlockPos blockPos, CompoundTag updateTag) {
        block25: {
            if (Minecraft.m_91087_().f_91073_ != null) {
                BlockEntity tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(blockPos);
                if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                    Optional<Block> convertedState;
                    BlockState currentState;
                    BlockState initializationState = currentState = Minecraft.m_91087_().f_91073_.m_8055_(blockPos);
                    if (currentState.m_60795_()) {
                        currentState = Blocks.f_50069_.m_49966_();
                    }
                    if ((convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isEmpty()) {
                        return;
                    }
                    Minecraft.m_91087_().f_91073_.m_7731_(blockPos, convertedState.get().m_49966_(), 4);
                    tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(blockPos);
                    if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                        return;
                    }
                }
                if (tileEntity != null && tileEntity.m_58904_() != null) {
                    try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Handling tile entity update packet");
                         IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Updating tile entity");){
                        if (tileEntity instanceof INetworkUpdateableEntity) {
                            INetworkUpdateableEntity networkUpdateableEntity = (INetworkUpdateableEntity)tileEntity;
                            networkUpdateableEntity.handleUpdateTag(updateTag);
                            break block25;
                        }
                        tileEntity.m_142466_(updateTag);
                        try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Scheduling refresh");){
                            tileEntity.m_58904_().m_7260_(tileEntity.m_58899_(), Blocks.f_50016_.m_49966_(), tileEntity.m_58900_(), 3);
                        }
                    }
                }
            }
        }
    }

    public static void handleChangeTrackerUpdated(CompoundTag tag) {
        IChangeTrackerManager.getInstance().getChangeTracker((Player)Minecraft.m_91087_().f_91074_).deserializeNBT(tag);
        if (Minecraft.m_91087_().f_91080_ instanceof AbstractChiselsAndBitsScreen) {
            ((AbstractChiselsAndBitsScreen)Minecraft.m_91087_().f_91080_).getWidgets().stream().filter(ChangeTrackerOperationsWidget.class::isInstance).map(ChangeTrackerOperationsWidget.class::cast).forEach(ChangeTrackerOperationsWidget::updateState);
        }
    }

    public static void handleNeighborUpdated(BlockPos toUpdate, BlockPos from) {
        Minecraft.m_91087_().f_91073_.m_8055_(toUpdate).m_60690_((Level)Minecraft.m_91087_().f_91073_, toUpdate, Minecraft.m_91087_().f_91073_.m_8055_(from).m_60734_(), from, false);
    }

    public static void handleAddMultiStateToClipboard(ItemStack stack) {
        SingleBlockMultiStateItemStack itemStack = new SingleBlockMultiStateItemStack(stack);
        CreativeClipboardUtils.addBrokenBlock(itemStack);
    }

    public static void handleExportPatternCommandMessage(BlockPos target, String name) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(target);
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to export pattern: " + name + " - Not a multistate block.")));
            return;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        IMultiStateItemStack multiStateItemStack = multiStateBlockEntity.createSnapshot().toItemStack();
        IPatternSharingManager.getInstance().exportPattern(multiStateItemStack, name);
    }

    public static void handleImportPatternCommandMessage(String name) {
        Either<IMultiStateItemStack, PatternIOException> importResult = IPatternSharingManager.getInstance().importPattern(name);
        importResult.ifLeft(stack -> ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new GivePlayerPatternCommandPacket(stack.toPatternStack())));
        importResult.ifRight(e -> Minecraft.m_91087_().f_91074_.m_213846_(e.getErrorMessage()));
    }
}

